# -*- coding: utf-8 -*-
from django.core.management.base import BaseCommand
import time
__author__ = 'Arvin'


class Command(BaseCommand):
    option_list = BaseCommand.option_list + ()
    help = "Start Integration Service."
    args = ''

    def handle(self, *args, **options):
        import datetime
        from mysite.worktable.integration_tasks import sync_employee, sync_area, sync_department, sync_job
        from django.db import close_connection, reset_queries
        sync_employee_tag = True
        sync_area_tag = True
        sync_department_tag = True
        sync_job_tag = True
        while True:
            try:
                now = datetime.datetime.now()
                if sync_employee_tag:
                    sync_employee(now)
                if sync_area_tag:
                    sync_area(now)
                if sync_department_tag:
                    sync_department(now)
                if sync_job_tag:
                    sync_job(now)
                reset_queries()
                time.sleep(5)
            except Exception, e:
                import traceback
                traceback.print_exc()
                close_connection()
                time.sleep(3 * 60)
                raise e